#!/usr/bin/perl
##############################################################################
# WWWBoard                      Version 2.0 ALPHA 2                          #
# Copyright 1996 Matt Wright    mattw@worldwidemart.com                      #
# Created 10/21/95              Last Modified 11/25/95                       #
# Scripts Archive at:           http://www.worldwidemart.com/scripts/        #
##############################################################################
# COPYRIGHT NOTICE                                                           #
# Copyright 1996 Matthew M. Wright  All Rights Reserved.                     #
#                                                                            #
# WWWBoard may be used and modified free of charge by anyone so long as      #
# this copyright notice and the comments above remain intact.  By using this #
# code you agree to indemnify Matthew M. Wright from any liability that      #  
# might arise from it's use.                                                 #  
#                                                                            #
# Selling the code for this program without prior written consent is         #
# expressly forbidden.  In other words, please ask first before you try and  #
# make money off of my program.                                              #
#                                                                            #
# Obtain permission before redistributing this software over the Internet or #
# in any other medium.  In all cases copyright and header must remain intact.#
##############################################################################
# Define Variables

#QװϪy|zAؿWYi
$basedir = "/usr1/home/kenwu/html/cgi-bin/bbs";

#QװϪsURLAؿWYi
$baseurl = "http://thor.prohosting.com/~kenwu/cgi-bin/bbs";

#board.plɪ|
$cgi_url = "http://thor.prohosting.com/~kenwu/cgi-bin/bbs/board.pl";

#s@XӪHTMLɪؿ(ק)
$mesgdir = "messages";

#pgƪɮ(ק)
$datafile = "data.txt";

#sɪHTML(ק)
$mesgfile = "index.htm";

#FAQHTML(ק)
$faqfile = "faq.htm";

#ͪHTMLɪɦW(ק)
$ext = "htm";

#AQװϪW
$title = "uWQ";

#U٦ݭnק諸
###########################################################################

###########################################################################
# Configure Options

$show_faq = 1;		# nX{FAQܡH 1 = YES; 0 = NO

$allow_html = 1;	# \ϥHTMLykܡH1 = YES; 0 = NO

$quote_text = 1;	# ^Юɤ\X{e@gTܡH1 = YES; 0 = NO

$subject_line = 0;	# ^ХDD泡  0 = ޥΫe@gDDAåiHۭqDD;
                                    # 1 = ޥΫe@gDDA\ۭqDD; 
			# 2 = ޥΫe@gDDA\ۭqDD.

$use_time = 1;		# nܮɶܡH 1 = YES; 0 = NO

#۰ʤҲͪI
$backimg ="/~kenwu/cgi-bin/guestbook/kenwusweb.gif";

#۰ʤҲͪIC
$bgcolor ="FFFFFF";

#۰ʤҲͪrC
$text ="000080";
#۰ʤҲͪsC
$link ="0000FF";

#۰ʤҲͪwXLsC
$vlink ="800080";

#sDDe
$question_img ="/~kenwu/cgi-bin/bbs/question.gif";

#^ХDDe
$idea_img ="/~kenwu/cgi-bin/bbs/idea.gif";

#Lק
$body_eval="bgcolor= \"$bgcolor\" text= \"$text\" link= \"$link\" vlink= \"$vlink\" background=\"$backimg\" ";

#U٦@ӭnק諸
###########################################################################
# New Variables and Multi Page Layout Information
# Create by Steven Miller Jr Email: webmaster@vaultworld.com
# Site http://www.vaultworld.com/cgi-scripts
# Last Updated: 2 Mar 98
###########################################################################
#Config Items
$use_proboard = 1; # 1 = YES; 0 = NO
$pageprefix = "bbs";   #This is the name of the multiply files ex polevault1.html

#uݭקo̡AJCX{h֥DDK۰ʤ
$perpagedisplay = 15; 

#LLק
#Note qq? and qq+ same as " but eliminates all \/ /" Stuff
$pagedirectoryfaq = qq? <center>[ <a href="#post">o峹</a> ][ <a href="faq.htm">FAQ</a> ][<a href="$mesgfile">s</a>]\n</center> ?;
$pagedirectory = qq? <center>[ <a href="#post">o峹</a> ][<a href="$mesgfile">s</a>]\n</center> ?;
$counter = qq+ <!-- Put Your Counter Code Here (Note Only Appears on Page One) --> +;
###Ads Banner Option
$show_ads = 0; #1 = Yes 0 = No
$adsbanner = qq+ <!-- Enter Your Banner Info Here--> +;
###################  No Need to Edit Below Lines   ################################
$ext2 = ".htm"; 
$pagename = "";
@page_contents = "";
$countpages = 0; # The Current Page Count
$pages_needed = 0; # Total Number of Pages Needed
$one = 1;
$firstpagename = $pageprefix . $one . $ext2;


# Done
###########################################################################

# Get the Data Number
&get_number;

# Get Form Information
&parse_form;

# Put items into nice variables
&get_variables;

# Open the new file and write information to it.
&new_file;

# Open the Main WWWBoard File to add link
&main_page;

# Now Add Thread to Individual Pages
if ($num_followups >= 1) {
   &thread_pages;
}

# Create on the fly Main WWWBoard File
if($use_proboard)
{
  &on_the_fly_main_page;
}

# Return the user HTML
if($use_proboard)
{
   &return_proboad;
}
else
{
   &return_html;
}
# Increment Number
&increment_num;

############################
# Get Data Number Subroutine

sub get_number {
   open(NUMBER,"$basedir/$datafile");
   $num = <NUMBER>;
   close(NUMBER);
   if ($num == 99999)  {
      $num = "1";
   }
   else {
      $num++;
   }
}

#######################
# Parse Form Subroutine

sub parse_form {

   # Get the input
   read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

   # Split the name-value pairs
   @pairs = split(/&/, $buffer);

   foreach $pair (@pairs) {
      ($name, $value) = split(/=/, $pair);

      # Un-Webify plus signs and %-encoding
      $value =~ tr/+/ /;
      $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
      $value =~ s/<!--(.|\n)*-->//g;

      if ($allow_html != 1) {
         $value =~ s/<([^>]|\n)*>//g;
      }
      else {
         unless ($name eq 'body') {
	    $value =~ s/<([^>]|\n)*>//g;
         }
      }

      $FORM{$name} = $value;
   }

}

###############
# Get Variables

sub get_variables {

   if ($FORM{'followup'}) {
      $followup = "1";
      @followup_num = split(/,/,$FORM{'followup'});
      $num_followups = @followups = @followup_num;
      $last_message = pop(@followups);
      $origdate = "$FORM{'origdate'}";
      $origname = "$FORM{'origname'}";
      $origsubject = "$FORM{'origsubject'}";
   }
   else {
      $followup = "0";
   }

   if ($FORM{'name'}) {
      $name = "$FORM{'name'}";
      $name =~ s/"//g;
      $name =~ s/<//g;
      $name =~ s/>//g;
      $name =~ s/\&//g;
   }
   else {
      &error(no_name);
   }

   if ($FORM{'email'} =~ /.*\@.*\..*/) {
      $email = "$FORM{'email'}";
   }

   if ($FORM{'subject'}) {
      $subject = "$FORM{'subject'}";
      $subject =~ s/\&/\&amp\;/g;
      $subject =~ s/"/\&quot\;/g;
   }
   else {
      &error(no_subject);
   }

   if ($FORM{'url'} =~ /.*\:.*\..*/ && $FORM{'url_title'}) {
      $message_url = "$FORM{'url'}";
      $message_url_title = "$FORM{'url_title'}";
   }

   if ($FORM{'img'} =~ /.*tp:\/\/.*\..*/) {
      $message_img = "$FORM{'img'}";
   }

   if ($FORM{'body'}) {
      $body = "$FORM{'body'}";
      $body =~ s/\cM//g;
      $body =~ s/\n\n/<p>/g;
      $body =~ s/\n/<br>/g;

      $body =~ s/&lt;/</g; 
      $body =~ s/&gt;/>/g; 
      $body =~ s/&quot;/"/g;
   }
   else {
      &error(no_body);
   }

   if ($quote_text == 1) {
      $hidden_body = "$body";
      $hidden_body =~ s/</&lt;/g;
      $hidden_body =~ s/>/&gt;/g;
      $hidden_body =~ s/"/&quot;/g;
   }

   ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);

   if ($sec < 10) {
      $sec = "0$sec";
   }
   if ($min < 10) {
      $min = "0$min";
   }
   if ($hour < 10) {
      $hour = "0$hour";
   }
   if ($mon < 10) {
      $mon = "0$mon";
   }
   if ($mday < 10) {
      $mday = "0$mday";
   }

   $month = ($mon + 1);

   @months = ("1","2","3","4","5","6","7","8","9","10","11","12");

   if ($use_time == 1) {
      $date = "$hour\:$min\:$sec $month/$mday/$year";
   }
   else {
      $date = "$month/$mday/$year";
   }
   chop($date) if ($date =~ /\n$/);

   $long_date = "19$year~$months[$mon]$mday$hour\:$min\:$sec";
}      

#####################
# New File Subroutine

sub new_file {

   open(NEWFILE,">$basedir/$mesgdir/$num\.$ext") || die $!;
   print NEWFILE "<html>\n";
   print NEWFILE "  <head>\n";
   print NEWFILE "    <title>$subject</title>\n";
   print NEWFILE "  </head>\n";
   print NEWFILE "  <body>\n";
   print NEWFILE "    <center>\n";
   print NEWFILE "      <h1>$subject</h1>\n";
   print NEWFILE "    </center>\n";
   print NEWFILE "<hr size=7 width=75%>\n";
   if ($show_faq == 1) {
      print NEWFILE "<center>[ <a href=\"#followups\">LH^</a> ] [ <a href=\"#postfp\">^Хg</a> ] [ <a href=\"$baseurl/$firstpagename\">$title</a> ] [ <a href=\"$baseurl/$faqfile\">FAQ</a> ]</center>\n";
   }
   else {
      print NEWFILE "<center>[ <a href=\"#followups\">LH^</a> ] [ <a href=\"#postfp\">^Хg</a> ] [ <a href=\"$baseurl/$firstpagename\">$title</a> ]</center>\n";
   }
   print NEWFILE "<hr size=7 width=75%><p>\n";

   print NEWFILE "oH ";

   if ($email) {
      print NEWFILE "<B><a href=\"mailto:$email\">$name</a></B>  $long_date<p>\n";
   }
   else {
      print NEWFILE "<B>$name</B>  $long_date<p>\n";
   }

   if ($followup == 1) {
      print NEWFILE "<B>DD:</B> <a href=\"$last_message\.$ext\">$origsubject</a> --";

      if ($origemail) {
         print NEWFILE "<a href=\"$origemail\">$origname</a> -- <font size=1>$origdate</font><p>\n";
      }
      else {
         print NEWFILE "$origname -- <font size=1>$origdate</font><p>\n";
      }
   }

   if ($message_img) {
      print NEWFILE "<center><img src=\"$message_img\"></center><p>\n";
   }
   print NEWFILE "$body\n";
   print NEWFILE "<br>\n";
   if ($message_url) {
      print NEWFILE "<ul><li><a href=\"$message_url\">$message_url_title</a></ul>\n";
   }
   print NEWFILE "<br><hr size=7 width=75%><p>\n";
   print NEWFILE "<a name=\"followups\"><B>LH^:</B></a><br>\n";
   print NEWFILE "<ul><!--insert: $num-->\n";
   print NEWFILE "</ul><!--end: $num-->\n";
   print NEWFILE "<br><hr size=7 width=75%><p>\n";
   print NEWFILE "<center><a name=\"postfp\"><B>^Хg</B></a></center><p>\n";
   print NEWFILE "<form method=POST action=\"$cgi_url\">\n";
   print NEWFILE "<input type=hidden name=\"followup\" value=\"";
   if ($followup == 1) {
      foreach $followup_num (@followup_num) {
         print NEWFILE "$followup_num,";
      }
   }
   print NEWFILE "$num\">\n";
   print NEWFILE "<input type=hidden name=\"origname\" value=\"$name\">\n";
   if ($email) {
      print NEWFILE "<input type=hidden name=\"origemail\" value=\"$email\">\n";
   }
   print NEWFILE "<input type=hidden name=\"origsubject\" value=\"$subject\">\n";
   print NEWFILE "<input type=hidden name=\"origdate\" value=\"$long_date\">\n";
   print NEWFILE "<center>zjW: <input type=text name=\"name\" size=50><br>\n";
   print NEWFILE "qlHc: <input type=text name=\"email\" size=50><br>\n";
   if ($subject_line == 1) {
      if ($subject_line =~ /^Re:/) {
         print NEWFILE "<input type=hidden name=\"subject\" value=\"$subject\">\n";
         print NEWFILE "oDD: <b>$subject</b><br>\n";
      }
      else {
         print NEWFILE "<input type=hidden name=\"subject\" value=\"Re: $subject\">\n";
         print NEWFILE "oDD: <b>Re: $subject</b><br>\n";
      }
   } 
   elsif ($subject_line == 2) {
      print NEWFILE "oDD: <input type=text name=\"subject\" size=50><br>\n";
   }
   else {
      if ($subject =~ /^Re:/) {
         print NEWFILE "oDD: <input type=text name=\"subject\"value=\"$subject\" size=50><br>\n";
      }
      else {
         print NEWFILE "oDD: <input type=text name=\"subject\" value=\"Re: $subject\" size=50><br>\n";
      }
   }
   print NEWFILE "Qפe:<br>\n";
   print NEWFILE "<textarea name=\"body\" COLS=50 ROWS=10>\n";
   if ($quote_text == 1) {
      @chunks_of_body = split(/\&lt\;p\&gt\;/,$hidden_body);
      foreach $chunk_of_body (@chunks_of_body) {
         @lines_of_body = split(/\&lt\;br\&gt\;/,$chunk_of_body);
         foreach $line_of_body (@lines_of_body) {
            print NEWFILE ": $line_of_body\n";
         }
         print NEWFILE "\n";
      }
   }
   print NEWFILE "</textarea>\n";
   print NEWFILE "<br>\n";
   print NEWFILE "ӤH}: <input type=text name=\"url\" size=50><br>\n";
   print NEWFILE "ӤHW: <input type=text name=\"url_title\" size=50><br>\n";
   print NEWFILE "s: <input type=text name=\"img\" size=50><br>\n";
   print NEWFILE "<input type=submit value=\" eX \"> <input type=reset value=\" M \"></center>\n";
   print NEWFILE "<p><hr size=7 width=75%>\n";
   if ($show_faq == 1) {
      print NEWFILE "<center>[ <a href=\"#followups\">LH^</a> ] [ <a href=\"#postfp\">^Хg</a> ] [ <a href=\"$baseurl/$firstpagename\">$title</a> ] [ <a href=\"$baseurl/$faqfile\">FAQ</a> ]</center>\n";
   }
   else {
      print NEWFILE "<center>[ <a href=\"#followups\">LH^</a> ] [ <a href=\"#postfp\">^Хg</a> ] [ <a href=\"$baseurl/$firstpagename\">$title</a> ]</center>\n";
   }
   print NEWFILE "</body></html>\n";
   close(NEWFILE);
}

###############################
# Main WWWBoard Page Subroutine

sub main_page {
   open(MAIN,"$basedir/$mesgfile") || die $!;
   @main = <MAIN>;
   close(MAIN);

   open(MAIN,">$basedir/$mesgfile") || die $!;
   if ($followup == 0) {
      foreach $main_line (@main) {
         if ($main_line =~ /<!--begin-->/) {
            print MAIN "<!--begin-->\n";
	    print MAIN "<!--top: $num--><li><img src=\"$question_img\"><a href=\"$mesgdir/$num\.$ext\">$subject</a> - <b>$name</b><font size=1><i>$date</i></font>\n";
            print MAIN "(<!--responses: $num-->0)\n";
            print MAIN "<ul><!--insert: $num-->\n";
            print MAIN "</ul><!--end: $num-->\n";
         }
         else {
            print MAIN "$main_line";
         }
      }
   }
   else {
      foreach $main_line (@main) {
	 $work = 0;
         if ($main_line =~ /<ul><!--insert: $last_message-->/) {
            print MAIN "<ul><!--insert: $last_message-->\n";
            print MAIN "<!--top: $num--><li><img src=\"$idea_img\"><a href=\"$mesgdir/$num\.$ext\">$subject</a> - <b>$name</b> <font size=1><i>$date</i></font>\n";
            print MAIN "(<!--responses: $num-->0)\n";
            print MAIN "<ul><!--insert: $num-->\n";
            print MAIN "</ul><!--end: $num-->\n";
         }
         elsif ($main_line =~ /\(<!--responses: (.*)-->(.*)\)/) {
            $response_num = $1;
            $num_responses = $2;
            $num_responses++;
            foreach $followup_num (@followup_num) {
               if ($followup_num == $response_num) {
                  print MAIN "(<!--responses: $followup_num-->$num_responses)\n";
		  $work = 1;
               }
            }
            if ($work != 1) {
               print MAIN "$main_line";
            }
         }
         else {
            print MAIN "$main_line";
         }
      }
   }
   close(MAIN);
}

############################################
# Add Followup Threading to Individual Pages
sub thread_pages {

   foreach $followup_num (@followup_num) {
      open(FOLLOWUP,"$basedir/$mesgdir/$followup_num\.$ext");
      @followup_lines = <FOLLOWUP>;
      close(FOLLOWUP);

      open(FOLLOWUP,">$basedir/$mesgdir/$followup_num\.$ext");
      foreach $followup_line (@followup_lines) {
         $work = 0;
         if ($followup_line =~ /<ul><!--insert: $last_message-->/) {
	    print FOLLOWUP "<ul><!--insert: $last_message-->\n";
            print FOLLOWUP "<!--top: $num--><li><img src=\"$idea_img\"><a href=\"$num\.$ext\">$subject</a> <b>$name</b> <font size=1><i>$date</i></font>\n";
            print FOLLOWUP "(<!--responses: $num-->0)\n";
            print FOLLOWUP "<ul><!--insert: $num-->\n";
            print FOLLOWUP "</ul><!--end: $num-->\n";
         }
         elsif ($followup_line =~ /\(<!--responses: (.*)-->(.*)\)/) {
            $response_num = $1;
            $num_responses = $2;
            $num_responses++;
            foreach $followup_num (@followup_num) {
               if ($followup_num == $response_num) {
                  print FOLLOWUP "(<!--responses: $followup_num-->$num_responses)\n";
                  $work = 1;
               }
            }
            if ($work != 1) {
               print FOLLOWUP "$followup_line";
            }
         }
         else {
            print FOLLOWUP "$followup_line";
         }
      }
      close(FOLLOWUP);
   }
}

sub return_html {
   print "Content-type: text/html\n\n";
   print "<html><head><title>[J峹: $subject</title></head>\n";
   print "<body><center><h1>[J峹: $subject</h1></center>\n";
   print "zoFHUTܰQװ:<p><hr size=7 width=75%><p>\n";
   print "<b>jW:</b> $name<br>\n";
   print "<b>E-Mail:</b> $email<br>\n";
   print "<b>DD:</b> $subject<br>\n";
   print "<b>e:</b><p>\n";
   print "$body<p>\n";
   if ($message_url) {
      print "<b>z}:</b> <a href=\"$message_url\">$message_url_title</a><br>\n";
   }
   if ($message_img) {
      print "<b>s:</b> <img src=\"$message_img\"><br>\n";
   }
   print "<b>[J:</b> $date<p>\n";
   print "<hr size=7 width=75%>\n";
   print "<center>[ <a href=\"$baseurl/$mesgdir/$num\.$ext\">[ݦG</a> ] [ <a href=\"$baseurl/$firstpagename\">$title</a> ]</center>\n";
   print "</body></html>\n";
}

sub increment_num {
   open(NUM,">$basedir/$datafile") || die $!;
   print NUM "$num";
   close(NUM);
}

sub error {
   $error = $_[0];

   print "Content-type: text/html\n\n";

   if ($error eq 'no_name') {
      print "<html><head><title>$title ~GLmW</title></head>\n";
      print "<body><center><h1>~GLmW</h1></center>\n";
      print "KIzӤ|OLWaIЫ^W@dӤjWaI<p><hr size=7 width=75%><p>\n";
      &rest_of_form;
   }
   elsif ($error eq 'no_subject') {
      print "<html><head><title>$title ~GLDD</title></head>\n";
      print "<body><center><h1>~GLDD</h1></center>\n";
      print "QӥDDaInhʰʸI<p><hr size=7 width=75%><p>\n";
      &rest_of_form;
   }
   elsif ($error eq 'no_body') {
      print "<html><head><title>$title ~GLe</title></head>\n";
      print "<body><center><h1>~GLe</h1></center>\n";
      print "zIA򳣤Anڭ̰QפOH<p><hr size=7 width=75%><p>\n";
      &rest_of_form;
   }
   else {
      print "~!  ]~\n";
   }
   exit;
}

sub rest_of_form {

   print "<form method=POST action=\"$cgi_url\">\n";

   if ($followup == 1) {
      print "<input type=hidden name=\"origsubject\" value=\"$FORM{'origsubject'}\">\n";
      print "<input type=hidden name=\"origname\" value=\"$FORM{'origname'}\">\n";
      print "<input type=hidden name=\"origemail\" value=\"$FORM{'origemail'}\">\n";
      print "<input type=hidden name=\"origdate\" value=\"$FORM{'origdate'}\">\n";
      print "<input type=hidden name=\"followup\" value=\"$FORM{'followup'}\">\n";
   }
   print "<center>zjW: <input type=text name=\"name\" value=\"$FORM{'name'}\" size=50><br>\n";
   print "qlHc: <input type=text name=\"email\" value=\"$FORM{'email'}\" size=50><br>\n";
   if ($subject_line == 1) {
      print "<input type=hidden name=\"subject\" value=\"$FORM{'subject'}\">\n";
      print "oDD: <b>$FORM{'subject'}</b><br>\n";
   } 
   else {
      print "oDD: <input type=text name=\"subject\" value=\"$FORM{'subject'}\" size=50><br>\n";
   }
   print "Qפe:<br>\n";
   print "<textarea COLS=50 ROWS=10 name=\"body\">\n";
   $FORM{'body'} =~ s/</&lt;/g;
   $FORM{'body'} =~ s/>/&gt;/g;
   $FORM{'body'} =~ s/"/&quot;/g;
   print "$FORM{'body'}\n";
   print "</textarea><br>\n";
   print "ӤH}: <input type=text name=\"url\" value=\"$FORM{'url'}\" size=50><br>\n";
   print "ӤHW: <input type=text name=\"url_title\" value=\"$FORM{'url_title'}\" size=50><br>\n";
   print "s: <input type=text name=\"img\" value=\"$FORM{'img'}\" size=50><br>\n";
   print "<input type=submit value=\" eX \"> <input type=reset value=\" M \">\n";
   print "</center></form>\n";
   print "<br><hr size=7 width=75%>\n";
   if ($show_faq == 1) {
      print "<center>[ <a href=\"#followups\">LH^</a> ] [ <a href=\"#postfp\">^Хg</a> ] [ <a href=\"$baseurl/$firstpagename\">$title</a> ] [ <a href=\"$baseurl/$faqfile\">FAQ</a> ]</center>\n";
   }
   else {
      print "<center>[ <a href=\"#followups\">LH^</a> ] [ <a href=\"#postfp\">^Хg</a> ] [ <a href=\"$baseurl/$firstpagename\">$title</a> ]</center>\n";
   }
   print "</body></html>\n";
}


#########################################################################################
#########################################################################################
# Multi Board Additions

############################
# On the Fly main page

sub on_the_fly_main_page
{
   $numofmainresponses = 0;
   open(MAIN,"$basedir/$mesgfile") || die $!;
   @maincopy = <MAIN>;
   close(MAIN);

   $number_of_lines_maincopy = @maincopy;
   

   #determine the number of main responses not replies
   for ($count = 0; $count < $number_of_lines_maincopy; $count++)
   {
      if ($maincopy[$count] =~ /<!--top: (\d*)-->*/)
      {
         $numofmainresponses++;
         $topvalue = $1;
         $count++;

         do
         {
            $count++;
         }while($maincopy[$count] !~ /<!--end: $topvalue-->*/);
                              

      }

   }

   #determine the interger number of pages
   

   $pages_needed = $numofmainresponses / $perpagedisplay;
   $pages_needed_remander = $numofmainresponses % $perpagedisplay;

   #Store In Interger Format
   $pages_needed = ($pages_needed - ($pages_needed_remander/$perpagedisplay));
   

   #Added one because a remainder
   if ($pages_needed_remander)
   {
      $pages_needed++;
   }
   

   
   #determine what type of pages to type
   if($numofmainresponses < $perpagedisplay)
   {
      #print only one page
      # Logic: Begin Storing Lines after first top and until bottom tag is found
      $detect = 0;
      $countpages = 1;
      for ($count = 0; $count < $number_of_lines_maincopy; $count++)
      {
         if ($maincopy[$count] =~ /<!--bottom.*/)
         {
            $detect = 0;
         }
         if ($maincopy[$count] =~ /<!--top:.*/ || $detect)
         {
         $detect = 1;
         splice(@page_contents, -1, 0, $maincopy[$count])
         }
      }
      #Call Write One page
      &write_one_page;
   }
   else
   {
      #print more than one page note starts at one the last page will be handle individually
      #Start from the beginning of a file.
      $count = 0;
      for($countpages = 1; $countpages < ($pages_needed + 1); $countpages++)
      {
         @page_contents = "";
         $detect = 0;
         for ($counttops = 0;$counttops < $perpagedisplay; )
         {
            # Read the next line of maincopy
            $count++;

            #Error Checking if page in wrong format will exit loop
            $maincopylength = @maincopy;
            if ($count == $maincopylength)
            {
               $counttops = $perpagedisplay;
            }
            if ($maincopy[$count] =~ /<!--bottom.*/)
            {
               $counttops = $perpagedisplay;  
            }
            if ($maincopy[$count] =~ /<!--top: (\d*)-->*/)
            {
               $topvalue = $1;
               $counttops++;
               $detect = 1;
               splice(@page_contents, -1, 0, $maincopy[$count]);

               #read and store until next top
               $count++;

               while($maincopy[$count] !~ /<!--end: $topvalue-->*/)
               {
                  splice(@page_contents, -1, 0, $maincopy[$count]);
                  $count++;

                  last if ($count == $maincopylength);

                  last if ($maincopy[$count] =~ /<!--bottom.*/);

               }
               # Still want to include last line would have used do loop
               # but it doens't support last statement
               splice(@page_contents, -1, 0, $maincopy[$count]);
                        

            }

            
         }

         # Call Print Pages
         &print_multi_pages ($countpages, @page_contents) ;
         

      }
   }
  

   
}

############################
# Write One Page Only

sub write_one_page
{
   # Finish by writing the Output to the File
   

   
   $pagename = $pageprefix . $one . $ext2;
   open (OUTFILE,">$basedir/$pagename")  || die $!;
   # print header
   &top_of_form2;
   print OUTFILE  "<ul>";
   # print body
   $number_of_lines_body = @page_contents;
        for ($count4 = 0; $count4 < $number_of_lines_body; $count4++)
   {
           print OUTFILE "$page_contents[$count4] \n";
   }

   #print ending
   &rest_of_form2;
   

   close(OUTFILE);

}

############################
# Write Multi Pages

sub print_multi_pages
{
   my ($countpages, @page_contents) = @_;
   # Finish by writing the Output to the File
   

   $pagename = $pageprefix . $countpages . $ext2;
   open (OUTFILE,">$basedir/$pagename")  || die $!;
   

   # print header
   &top_of_form2;
   &print_page_numbers;
   print OUTFILE  "<ul>";
   

   # print body
   $number_of_lines_body = @page_contents;
        for ($count4 = 0; $count4 < $number_of_lines_body; $count4++)
   {
           print OUTFILE "$page_contents[$count4] \n";
   }

   #print ending
   &rest_of_form2;
   

   close(OUTFILE);

}
#####################################################################################
# Write to of the Rest of the Form

sub rest_of_form2 {
   print OUTFILE qq? <a name="post"><center><h2>iK峹</h2></center></a><br> \n?;
   print OUTFILE "<form method=POST action=\"$cgi_url\">\n";
   print OUTFILE "<center>zjW: <input type=text name=\"name\" value=\"\" size=50><br>\n";
   print OUTFILE "qlHc: <input type=text name=\"email\" value=\"\" size=50><br>\n";
   print OUTFILE "oDD: <input type=text name=\"subject\" value=\"\" size=50><br>\n";
   print OUTFILE "Qפe:<br>\n";
   print OUTFILE "<textarea COLS=50 ROWS=10 name=\"body\">\n";
   print OUTFILE "</textarea><br>\n";
   print OUTFILE "ӤH}: <input type=text name=\"url\" value=\"\" size=50><br>\n";
   print OUTFILE "ӤHW: <input type=text name=\"url_title\" value=\"\" size=50><br>\n";
   print OUTFILE "s: <input type=text name=\"img\" value=\"\" size=50><br>\n";
   print OUTFILE "<input type=submit value=\" eX \"> <input type=reset value=\" M \">\n";
   print OUTFILE "</center></form>\n";
   print OUTFILE "<br><hr size=7 width=75%>\n";
   print OUTFILE "<font size=2>l{<a href=\"http://worldwidemart.com/scripts/\" target=\"new\">Matt's Script Archive</a></font>\n";
   print OUTFILE "<font size=2>{ק<a href=\"http://www.vaultworld.com/cgi-scripts\" target=\"new\">Steven Miller Jr</a></font>\n";
   print OUTFILE "<font size=2>ק<a href=\"http://come.to/kenwu\" target=\"new\">CR</a></font>\n";

   if($pages_needed != 1)
   {
   &print_page_numbers;
   }

   if($countpages == 1)
   {
      print OUTFILE "<br> $counter \n";
   }
   print OUTFILE "</body></html>\n";
}

#####################################################################################
# Write to of the Form for One Page Only
sub top_of_form2 {
   print OUTFILE "<html>\n";
   print OUTFILE "  <head>\n";
   print OUTFILE "    <title>$title</title>\n";
   print OUTFILE "  </head>\n";
   print OUTFILE "  <body $body_eval>\n";
   print OUTFILE "    <center>\n";
   print OUTFILE "      <h1>$title</h1>\n";
   print OUTFILE "    </center>\n";
   print OUTFILE "<hr size=7 width=75%>\n";

   if ($show_faq == 1) {
      print OUTFILE $pagedirectoryfaq;
   }
   else {
      print OUTFILE $pagedirectory;
   }
   

   print OUTFILE "<hr size=7 width=75%>\n";

   if ($show_ads == 1) {
      print OUTFILE $adsbanner;
      print OUTFILE "<hr size=7 width=75%>\n";
   }

}

#########################################################################################
# Proboard Return

sub return_proboad {
   print "Content-type: text/html\n\n";
   print "<html><head><title>[J峹: $subject</title></head>\n";
   print "<body $body_eval><center><h1>[J峹: $subject</h1></center>\n";
   print "zoFHUTQװ:<p><hr size=7 width=75%><p>\n";
   print "<b>jW:</b> $name<br>\n";
   print "<b>E-Mail:</b> $email<br>\n";
   print "<b>DD:</b> $subject<br>\n";
   print "<b>e:</b><p>\n";
   print "$body<p>\n";
   if ($message_url) {
      print "<b>z:</b> <a href=\"$message_url\">$message_url_title</a><br>\n";
   }
   if ($message_img) {
      print "<b>LOGO:</b> <img src=\"$message_img\"><br>\n";
   }
   print "<b>oɶ:</b> $date<p>\n";
   print "<hr size=7 width=75%>\n";
   print "<center>[ <a href=\"$baseurl/$mesgdir/$num\.$ext\">[ݦG</a> ] [ <a href=\"$baseurl/$firstpagename\">$title</a> ]</center>\n";
   print "</body></html>\n";
}

#####################################################################################
# Write to of the Form for One Page Only
sub print_page_numbers
{

   $pagename = $pageprefix . $countpages . $ext2;
   $pagenameminus = $pageprefix . ($countpages - 1) . $ext2;
   $pagenamemore = $pageprefix . ($countpages + 1) . $ext2;

   if($countpages == 1)
   {
      print OUTFILE "<center>\n";
      for ($i = 1; $i <= $pages_needed; $i++)
      {
         if ($i == ($countpages + 10))
         {
            #Note qq? same as " but eliminates all \/ /" Stuff
            print OUTFILE qq? <a href="$pageprefix$i$ext2">[Next]</a> <b>$pages_needed Total Pages</b> \n ?;
         }
         # exit out of for loop
         last if ($i == ($countpages + 10));

         if ($i == $countpages)
         {
            print OUTFILE qq? [<a href="$pageprefix$i$ext2"><font size =+2>$i</font></a>]?;
         }
         else
         {
            print OUTFILE qq? [<a href="$pageprefix$i$ext2">$i</a>]?;
         }
      }
      print OUTFILE "</center>\n";
      print OUTFILE "<hr size=7 width=75%>\n";
   }
   elsif($countpages == $pages_needed)
   {
      if ($pages_needed > 10)
      {
         

         print OUTFILE "<center>\n";
         #Note qq? same as " but eliminates all \/ /" Stuff
         $i = $pages_needed - 11;
         print OUTFILE qq? [<a href="$pageprefix$i$ext2">Previous</a>]?;
         

         for ($i = $pages_needed - 10; $i <= $pages_needed; $i++)
         {

            if ($i == $countpages)
            {
               print OUTFILE qq? [<a href="$pageprefix$i$ext2"><font size =+2>$i</font></a>]?;
            }
            else
            {
                  print OUTFILE qq? [<a href="$pageprefix$i$ext2">$i</a>]?;
            }
         }
         print OUTFILE "</center>\n";
         print OUTFILE "<hr size=7 width=75%>\n";
      }
      else
      {
         print OUTFILE "<center>\n";
         for ($i = 1; $i <= $pages_needed; $i++)
         {
            if ($i == $countpages)
            {
               print OUTFILE qq? [<a href="$pageprefix$i$ext2"><font size =+2>$i</font></a>]?;
            }
            else
            {
                  print OUTFILE qq? [<a href="$pageprefix$i$ext2">$i</a>]?;
            }
         }
         print OUTFILE "</center>\n";
         print OUTFILE "<hr size=7 width=75%>\n";
      }
   }
   else
   {
      if ($pages_needed > 10)
      {
         

         print OUTFILE "<center>\n";
         #Note qq? same as " but eliminates all \/ /" Stuff
         $i = $countpages - 1;
         print OUTFILE qq? [<a href="$pageprefix$i$ext2">eQ</a>]?;
         

         for ($i = $countpages; $i <= $pages_needed; $i++)
         {

            if ($i == ($countpages + 10))
            {
               #Note qq? same as " but eliminates all \/ /" Stuff
               print OUTFILE qq?[<a href="$pageprefix$i$ext2">Q</a>]  `p $pages_needed \n?;
            }
            # exit out of for loop
            last if ($i == ($countpages + 10));
         

            if ($i == $countpages)
            {
               print OUTFILE qq?[<a href="$pageprefix$i$ext2"><font size =+2>$i</font></a>]?;
            }
            else
            {
                  print OUTFILE qq?[<a href="$pageprefix$i$ext2">$i</a>]?;
            }
         }
         print OUTFILE "</center>\n";
         print OUTFILE "<hr size=7 width=75%>\n";
      }
      else
      {
         print OUTFILE "<center>\n";
         for ($i = 1; $i <= $pages_needed; $i++)
         {
            if ($i == $countpages)
            {
               print OUTFILE qq?[<a href="$pageprefix$i$ext2"><font size =+2>$i</font></a>]?;
            }
            else
            {
                  print OUTFILE qq?[<a href="$pageprefix$i$ext2">$i</a>]?;
            }
         }
         print OUTFILE "</center>\n";
         print OUTFILE "<hr size=7 width=75%>\n";
      }
   }

}

 

# End Multi Board Additions
#########################################################################################
#########################################################################################